/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  uart.c
//  MCU board for 2KW Battery Charger

//  Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//  April, 2014 - Version 1.00
//  Built with Code Composer Studio Core Edition Version: 5.5.0.00077
//
//	Device: MPS430F2252
//
//******************************************************************************
//******************************************************************************
//   MSP430F22x4 Demo - USCI_A0, UART 9600 RX/TX, 16MHz SMCLK
//
//   Description: This program demonstrates a full-duplex 9600-baud UART using
//   USCI_A0.  The program will receive
//   a string1 into RAM, and echo back the complete string.
//   Baud rate divider with 16MHz oscillator @ 9600 = 16000000/9600 = 1666
//
//                MSP430F2252
//             -----------------
//         /|\|                 |-
//          | |                 |
//          --|RST              |-
//            |                 |
//            |     P3.4/UCA0TXD|------------>
//            |                 | 9600 - 8N1
//            |     P3.5/UCA0RXD|<------------
//
//

#include "main.h"

char i;
char j = 0;

// USCI Transmit ISR
#pragma vector = USCIAB0TX_VECTOR
__interrupt void USCI0TX_ISR(void)
{
  UCA0TXBUF = string1[char_number++];                 // TX next character

  if (char_number == sizeof string1)                  // TX over?
  {
	  IE2 &= ~UCA0TXIE;                       // Disable USCI_A0 TX interrupt
	  char_number=0;
	  Flag_Transmission_Done = 1;				// String sent = Flag transmission done = 1
  }
}

// USCI Receive ISR
#pragma vector = USCIAB0RX_VECTOR
__interrupt void USCI0RX_ISR(void)
{
	if(j>0)
		{
		receive_string[j] = UCA0RXBUF;
		if (receive_string[j] == '#')	j = 0;
		else j = j + 1;
		}
	if (((receive_string[1] == 'M')&&(master_slave>10))||((receive_string[1] == 'S')&&(master_slave<10)))
	{

	}
	else
	{
		j = 0; // receive a command only if it is a slave
	}

	if(UCA0RXBUF=='#')
	{
		j=0;
		receive_string[j++] = UCA0RXBUF;
	}


  if (j > 5)
	  {
	  Flag_String_Received = 1;
	  	  j = 0;
	  }

}
